# Getting Started

In `examples/`, we included a wide variety of examples that showed how federated learning algorithms in the research literature can be implemented using Plato by customizing the `client`, `server`, `algorithm`, and `trainer` classes.

## Available Examples

- [Server Aggregation Algorithms](algorithms/1.%20Server%20Aggregation%20Algorithms.md)

- [Secure Aggregation with Homomorphic Encryption](algorithms/2.%20Secure%20Aggregation%20with%20Homomorphic%20Encryption.md)

- [Asynchronous Federated Learning Algorithms](algorithms/3.%20Asynchronous%20Federated%20Learning%20Algorithms.md)

- [Federated Unlearning](algorithms/4.%20Federated%20Unlearning.md)

- [Algorithms with Customized Client Training Loops](algorithms/5.%20Algorithms%20with%20Customized%20Client%20Training%20Loops.md)

- [Client Selection Algorithms](algorithms/6.%20Client%20Selection%20Algorithms.md)

- [Split Learning Algorithms](algorithms/7.%20Split%20Learning%20Algorithms.md)

- [Personalized Federated Learning Algorithms](algorithms/8.%20Personalized%20Federated%20Learning%20Algorithms.md)

- [Personalized Federated Learning Algorithms based on Self-Supervised Learning](algorithms/9.%20Personalized%20Federated%20Learning%20Algorithms%20based%20on%20Self-Supervised%20Learning.md)

- [Algorithms based on Neural Architecture Search and Model Search](algorithms/10.%20Algorithms%20based%20on%20Neural%20Architecture%20Search%20and%20Model%20Search.md)

- [Three-layer Federated Learning Algorithms](algorithms/11.%20Three-layer%20Federated%20Learning%20Algorithms.md)

- [Poisoning Detection Algorithms](algorithms/12.%20Poisoning%20Detection%20Algorithms.md)

- [Model Pruning Algorithms](algorithms/13.%20Model%20Pruning%20Algorithms.md)

---


## Getting Started

### Prerequisites

Before running any examples, you'll need to complete two important steps:

#### 1. Download the Dataset

On your first run, you must download the required dataset using the `-d` flag:

```bash
uv run examples/personalized_fl/fedbabu/fedbabu.py \
  -c examples/personalized_fl/configs/fedbabu_CIFAR10_resnet18.yml -d
```

Wait for the confirmation message:

```bash
The dataset has been successfully downloaded. Re-run the experiment without '-d' or '--download'.
```

Then run the command again **without** the `-d` flag:

```bash
uv run examples/personalized_fl/fedbabu/fedbabu.py \
  -c examples/personalized_fl/configs/fedbabu_CIFAR10_resnet18.yml
```

#### 2. Install Dependencies

Plato uses **uv** for hierarchical dependency management. Example-specific packages are defined in local `pyproject.toml` files rather than in the root directory.

To run an example with its dependencies:

1. Navigate to the example directory
2. Execute using `uv run`

**Example:**

```bash
cd examples/ssl/smog
uv run smog.py -c ../../../examples/ssl/configs/smog_CIFAR10_resnet18.yml
```

**Important:**
    *Always run `uv run` from within the specific example directory to ensure all dependencies are properly loaded.*

---
